// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity SQL Data Warehouse sink.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SqlDWSink.class, visible = true)
@JsonTypeName("SqlDWSink")
@Fluent
public final class SqlDWSink extends CopySink {
    /*
     * Copy sink type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SqlDWSink";

    /*
     * SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "preCopyScript")
    private Object preCopyScript;

    /*
     * Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "allowPolyBase")
    private Object allowPolyBase;

    /*
     * Specifies PolyBase-related settings when allowPolyBase is true.
     */
    @JsonProperty(value = "polyBaseSettings")
    private PolybaseSettings polyBaseSettings;

    /*
     * Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "allowCopyCommand")
    private Object allowCopyCommand;

    /*
     * Specifies Copy Command related settings when allowCopyCommand is true.
     */
    @JsonProperty(value = "copyCommandSettings")
    private DWCopyCommandSettings copyCommandSettings;

    /*
     * The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tableOption")
    private Object tableOption;

    /*
     * Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "sqlWriterUseTableLock")
    private Object sqlWriterUseTableLock;

    /*
     * Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
     */
    @JsonProperty(value = "writeBehavior")
    private Object writeBehavior;

    /*
     * SQL DW upsert settings.
     */
    @JsonProperty(value = "upsertSettings")
    private SqlDWUpsertSettings upsertSettings;

    /**
     * Creates an instance of SqlDWSink class.
     */
    public SqlDWSink() {
    }

    /**
     * Get the type property: Copy sink type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the preCopyScript property: SQL pre-copy script. Type: string (or Expression with resultType string).
     * 
     * @return the preCopyScript value.
     */
    public Object preCopyScript() {
        return this.preCopyScript;
    }

    /**
     * Set the preCopyScript property: SQL pre-copy script. Type: string (or Expression with resultType string).
     * 
     * @param preCopyScript the preCopyScript value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    /**
     * Get the allowPolyBase property: Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable.
     * Type: boolean (or Expression with resultType boolean).
     * 
     * @return the allowPolyBase value.
     */
    public Object allowPolyBase() {
        return this.allowPolyBase;
    }

    /**
     * Set the allowPolyBase property: Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable.
     * Type: boolean (or Expression with resultType boolean).
     * 
     * @param allowPolyBase the allowPolyBase value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withAllowPolyBase(Object allowPolyBase) {
        this.allowPolyBase = allowPolyBase;
        return this;
    }

    /**
     * Get the polyBaseSettings property: Specifies PolyBase-related settings when allowPolyBase is true.
     * 
     * @return the polyBaseSettings value.
     */
    public PolybaseSettings polyBaseSettings() {
        return this.polyBaseSettings;
    }

    /**
     * Set the polyBaseSettings property: Specifies PolyBase-related settings when allowPolyBase is true.
     * 
     * @param polyBaseSettings the polyBaseSettings value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withPolyBaseSettings(PolybaseSettings polyBaseSettings) {
        this.polyBaseSettings = polyBaseSettings;
        return this;
    }

    /**
     * Get the allowCopyCommand property: Indicates to use Copy Command to copy data into SQL Data Warehouse. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @return the allowCopyCommand value.
     */
    public Object allowCopyCommand() {
        return this.allowCopyCommand;
    }

    /**
     * Set the allowCopyCommand property: Indicates to use Copy Command to copy data into SQL Data Warehouse. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @param allowCopyCommand the allowCopyCommand value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withAllowCopyCommand(Object allowCopyCommand) {
        this.allowCopyCommand = allowCopyCommand;
        return this;
    }

    /**
     * Get the copyCommandSettings property: Specifies Copy Command related settings when allowCopyCommand is true.
     * 
     * @return the copyCommandSettings value.
     */
    public DWCopyCommandSettings copyCommandSettings() {
        return this.copyCommandSettings;
    }

    /**
     * Set the copyCommandSettings property: Specifies Copy Command related settings when allowCopyCommand is true.
     * 
     * @param copyCommandSettings the copyCommandSettings value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withCopyCommandSettings(DWCopyCommandSettings copyCommandSettings) {
        this.copyCommandSettings = copyCommandSettings;
        return this;
    }

    /**
     * Get the tableOption property: The option to handle sink table, such as autoCreate. For now only 'autoCreate'
     * value is supported. Type: string (or Expression with resultType string).
     * 
     * @return the tableOption value.
     */
    public Object tableOption() {
        return this.tableOption;
    }

    /**
     * Set the tableOption property: The option to handle sink table, such as autoCreate. For now only 'autoCreate'
     * value is supported. Type: string (or Expression with resultType string).
     * 
     * @param tableOption the tableOption value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    /**
     * Get the sqlWriterUseTableLock property: Whether to use table lock during bulk copy. Type: boolean (or Expression
     * with resultType boolean).
     * 
     * @return the sqlWriterUseTableLock value.
     */
    public Object sqlWriterUseTableLock() {
        return this.sqlWriterUseTableLock;
    }

    /**
     * Set the sqlWriterUseTableLock property: Whether to use table lock during bulk copy. Type: boolean (or Expression
     * with resultType boolean).
     * 
     * @param sqlWriterUseTableLock the sqlWriterUseTableLock value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withSqlWriterUseTableLock(Object sqlWriterUseTableLock) {
        this.sqlWriterUseTableLock = sqlWriterUseTableLock;
        return this;
    }

    /**
     * Get the writeBehavior property: Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum
     * (or Expression with resultType SqlDWWriteBehaviorEnum).
     * 
     * @return the writeBehavior value.
     */
    public Object writeBehavior() {
        return this.writeBehavior;
    }

    /**
     * Set the writeBehavior property: Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum
     * (or Expression with resultType SqlDWWriteBehaviorEnum).
     * 
     * @param writeBehavior the writeBehavior value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    /**
     * Get the upsertSettings property: SQL DW upsert settings.
     * 
     * @return the upsertSettings value.
     */
    public SqlDWUpsertSettings upsertSettings() {
        return this.upsertSettings;
    }

    /**
     * Set the upsertSettings property: SQL DW upsert settings.
     * 
     * @param upsertSettings the upsertSettings value to set.
     * @return the SqlDWSink object itself.
     */
    public SqlDWSink withUpsertSettings(SqlDWUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDWSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (polyBaseSettings() != null) {
            polyBaseSettings().validate();
        }
        if (copyCommandSettings() != null) {
            copyCommandSettings().validate();
        }
        if (upsertSettings() != null) {
            upsertSettings().validate();
        }
    }
}
