// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SSIS access credential.
 */
@Fluent
public final class SsisAccessCredential {
    /*
     * Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "domain", required = true)
    private Object domain;

    /*
     * UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName", required = true)
    private Object username;

    /*
     * Password for windows authentication.
     */
    @JsonProperty(value = "password", required = true)
    private SecretBase password;

    /**
     * Creates an instance of SsisAccessCredential class.
     */
    public SsisAccessCredential() {
    }

    /**
     * Get the domain property: Domain for windows authentication. Type: string (or Expression with resultType string).
     * 
     * @return the domain value.
     */
    public Object domain() {
        return this.domain;
    }

    /**
     * Set the domain property: Domain for windows authentication. Type: string (or Expression with resultType string).
     * 
     * @param domain the domain value to set.
     * @return the SsisAccessCredential object itself.
     */
    public SsisAccessCredential withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    /**
     * Get the username property: UseName for windows authentication. Type: string (or Expression with resultType
     * string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: UseName for windows authentication. Type: string (or Expression with resultType
     * string).
     * 
     * @param username the username value to set.
     * @return the SsisAccessCredential object itself.
     */
    public SsisAccessCredential withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password for windows authentication.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password for windows authentication.
     * 
     * @param password the password value to set.
     * @return the SsisAccessCredential object itself.
     */
    public SsisAccessCredential withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (domain() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property domain in model SsisAccessCredential"));
        }
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property username in model SsisAccessCredential"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property password in model SsisAccessCredential"));
        } else {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SsisAccessCredential.class);
}
