// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Ssis environment.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SsisEnvironment.class, visible = true)
@JsonTypeName("Environment")
@Fluent
public final class SsisEnvironment extends SsisObjectMetadata {
    /*
     * Type of metadata.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private SsisObjectMetadataType type = SsisObjectMetadataType.ENVIRONMENT;

    /*
     * Folder id which contains environment.
     */
    @JsonProperty(value = "folderId")
    private Long folderId;

    /*
     * Variable in environment
     */
    @JsonProperty(value = "variables")
    private List<SsisVariable> variables;

    /**
     * Creates an instance of SsisEnvironment class.
     */
    public SsisEnvironment() {
    }

    /**
     * Get the type property: Type of metadata.
     * 
     * @return the type value.
     */
    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    /**
     * Get the folderId property: Folder id which contains environment.
     * 
     * @return the folderId value.
     */
    public Long folderId() {
        return this.folderId;
    }

    /**
     * Set the folderId property: Folder id which contains environment.
     * 
     * @param folderId the folderId value to set.
     * @return the SsisEnvironment object itself.
     */
    public SsisEnvironment withFolderId(Long folderId) {
        this.folderId = folderId;
        return this;
    }

    /**
     * Get the variables property: Variable in environment.
     * 
     * @return the variables value.
     */
    public List<SsisVariable> variables() {
        return this.variables;
    }

    /**
     * Set the variables property: Variable in environment.
     * 
     * @param variables the variables value to set.
     * @return the SsisEnvironment object itself.
     */
    public SsisEnvironment withVariables(List<SsisVariable> variables) {
        this.variables = variables;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisEnvironment withId(Long id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisEnvironment withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisEnvironment withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (variables() != null) {
            variables().forEach(e -> e.validate());
        }
    }
}
