// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SSIS package execution credential.
 */
@Fluent
public final class SsisExecutionCredential {
    /*
     * Domain for windows authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "domain", required = true)
    private Object domain;

    /*
     * UseName for windows authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName", required = true)
    private Object username;

    /*
     * Password for windows authentication.
     */
    @JsonProperty(value = "password", required = true)
    private SecureString password;

    /**
     * Creates an instance of SsisExecutionCredential class.
     */
    public SsisExecutionCredential() {
    }

    /**
     * Get the domain property: Domain for windows authentication. Type: string (or Expression with resultType string).
     * 
     * @return the domain value.
     */
    public Object domain() {
        return this.domain;
    }

    /**
     * Set the domain property: Domain for windows authentication. Type: string (or Expression with resultType string).
     * 
     * @param domain the domain value to set.
     * @return the SsisExecutionCredential object itself.
     */
    public SsisExecutionCredential withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    /**
     * Get the username property: UseName for windows authentication. Type: string (or Expression with resultType
     * string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: UseName for windows authentication. Type: string (or Expression with resultType
     * string).
     * 
     * @param username the username value to set.
     * @return the SsisExecutionCredential object itself.
     */
    public SsisExecutionCredential withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password for windows authentication.
     * 
     * @return the password value.
     */
    public SecureString password() {
        return this.password;
    }

    /**
     * Set the password property: Password for windows authentication.
     * 
     * @param password the password value to set.
     * @return the SsisExecutionCredential object itself.
     */
    public SsisExecutionCredential withPassword(SecureString password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (domain() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property domain in model SsisExecutionCredential"));
        }
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model SsisExecutionCredential"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model SsisExecutionCredential"));
        } else {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SsisExecutionCredential.class);
}
