// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Ssis folder.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SsisFolder.class, visible = true)
@JsonTypeName("Folder")
@Fluent
public final class SsisFolder extends SsisObjectMetadata {
    /*
     * Type of metadata.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private SsisObjectMetadataType type = SsisObjectMetadataType.FOLDER;

    /**
     * Creates an instance of SsisFolder class.
     */
    public SsisFolder() {
    }

    /**
     * Get the type property: Type of metadata.
     * 
     * @return the type value.
     */
    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisFolder withId(Long id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisFolder withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SsisFolder withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
