// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Ssis parameter.
 */
@Fluent
public final class SsisParameter {
    /*
     * Parameter id.
     */
    @JsonProperty(value = "id")
    private Long id;

    /*
     * Parameter name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Parameter description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Parameter type.
     */
    @JsonProperty(value = "dataType")
    private String dataType;

    /*
     * Whether parameter is required.
     */
    @JsonProperty(value = "required")
    private Boolean required;

    /*
     * Whether parameter is sensitive.
     */
    @JsonProperty(value = "sensitive")
    private Boolean sensitive;

    /*
     * Design default value of parameter.
     */
    @JsonProperty(value = "designDefaultValue")
    private String designDefaultValue;

    /*
     * Default value of parameter.
     */
    @JsonProperty(value = "defaultValue")
    private String defaultValue;

    /*
     * Default sensitive value of parameter.
     */
    @JsonProperty(value = "sensitiveDefaultValue")
    private String sensitiveDefaultValue;

    /*
     * Parameter value type.
     */
    @JsonProperty(value = "valueType")
    private String valueType;

    /*
     * Parameter value set.
     */
    @JsonProperty(value = "valueSet")
    private Boolean valueSet;

    /*
     * Parameter reference variable.
     */
    @JsonProperty(value = "variable")
    private String variable;

    /**
     * Creates an instance of SsisParameter class.
     */
    public SsisParameter() {
    }

    /**
     * Get the id property: Parameter id.
     * 
     * @return the id value.
     */
    public Long id() {
        return this.id;
    }

    /**
     * Set the id property: Parameter id.
     * 
     * @param id the id value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Parameter name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Parameter name.
     * 
     * @param name the name value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Parameter description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Parameter description.
     * 
     * @param description the description value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the dataType property: Parameter type.
     * 
     * @return the dataType value.
     */
    public String dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: Parameter type.
     * 
     * @param dataType the dataType value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Get the required property: Whether parameter is required.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Whether parameter is required.
     * 
     * @param required the required value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the sensitive property: Whether parameter is sensitive.
     * 
     * @return the sensitive value.
     */
    public Boolean sensitive() {
        return this.sensitive;
    }

    /**
     * Set the sensitive property: Whether parameter is sensitive.
     * 
     * @param sensitive the sensitive value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
        return this;
    }

    /**
     * Get the designDefaultValue property: Design default value of parameter.
     * 
     * @return the designDefaultValue value.
     */
    public String designDefaultValue() {
        return this.designDefaultValue;
    }

    /**
     * Set the designDefaultValue property: Design default value of parameter.
     * 
     * @param designDefaultValue the designDefaultValue value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withDesignDefaultValue(String designDefaultValue) {
        this.designDefaultValue = designDefaultValue;
        return this;
    }

    /**
     * Get the defaultValue property: Default value of parameter.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: Default value of parameter.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the sensitiveDefaultValue property: Default sensitive value of parameter.
     * 
     * @return the sensitiveDefaultValue value.
     */
    public String sensitiveDefaultValue() {
        return this.sensitiveDefaultValue;
    }

    /**
     * Set the sensitiveDefaultValue property: Default sensitive value of parameter.
     * 
     * @param sensitiveDefaultValue the sensitiveDefaultValue value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withSensitiveDefaultValue(String sensitiveDefaultValue) {
        this.sensitiveDefaultValue = sensitiveDefaultValue;
        return this;
    }

    /**
     * Get the valueType property: Parameter value type.
     * 
     * @return the valueType value.
     */
    public String valueType() {
        return this.valueType;
    }

    /**
     * Set the valueType property: Parameter value type.
     * 
     * @param valueType the valueType value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    /**
     * Get the valueSet property: Parameter value set.
     * 
     * @return the valueSet value.
     */
    public Boolean valueSet() {
        return this.valueSet;
    }

    /**
     * Set the valueSet property: Parameter value set.
     * 
     * @param valueSet the valueSet value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withValueSet(Boolean valueSet) {
        this.valueSet = valueSet;
        return this;
    }

    /**
     * Get the variable property: Parameter reference variable.
     * 
     * @return the variable value.
     */
    public String variable() {
        return this.variable;
    }

    /**
     * Set the variable property: Parameter reference variable.
     * 
     * @param variable the variable value to set.
     * @return the SsisParameter object itself.
     */
    public SsisParameter withVariable(String variable) {
        this.variable = variable;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
