// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * Staging settings.
 */
@Fluent
public final class StagingSettings {
    /*
     * Staging linked service reference.
     */
    @JsonProperty(value = "linkedServiceName", required = true)
    private LinkedServiceReference linkedServiceName;

    /*
     * The path to storage for storing the interim data. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "path")
    private Object path;

    /*
     * Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableCompression")
    private Object enableCompression;

    /*
     * Staging settings.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of StagingSettings class.
     */
    public StagingSettings() {
    }

    /**
     * Get the linkedServiceName property: Staging linked service reference.
     * 
     * @return the linkedServiceName value.
     */
    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    /**
     * Set the linkedServiceName property: Staging linked service reference.
     * 
     * @param linkedServiceName the linkedServiceName value to set.
     * @return the StagingSettings object itself.
     */
    public StagingSettings withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    /**
     * Get the path property: The path to storage for storing the interim data. Type: string (or Expression with
     * resultType string).
     * 
     * @return the path value.
     */
    public Object path() {
        return this.path;
    }

    /**
     * Set the path property: The path to storage for storing the interim data. Type: string (or Expression with
     * resultType string).
     * 
     * @param path the path value to set.
     * @return the StagingSettings object itself.
     */
    public StagingSettings withPath(Object path) {
        this.path = path;
        return this;
    }

    /**
     * Get the enableCompression property: Specifies whether to use compression when copying data via an interim
     * staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableCompression value.
     */
    public Object enableCompression() {
        return this.enableCompression;
    }

    /**
     * Set the enableCompression property: Specifies whether to use compression when copying data via an interim
     * staging. Default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableCompression the enableCompression value to set.
     * @return the StagingSettings object itself.
     */
    public StagingSettings withEnableCompression(Object enableCompression) {
        this.enableCompression = enableCompression;
        return this;
    }

    /**
     * Get the additionalProperties property: Staging settings.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Staging settings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the StagingSettings object itself.
     */
    public StagingSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedServiceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property linkedServiceName in model StagingSettings"));
        } else {
            linkedServiceName().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StagingSettings.class);
}
