// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SynapseNotebookActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Execute Synapse notebook activity.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SynapseNotebookActivity.class,
    visible = true)
@JsonTypeName("SynapseNotebook")
@Fluent
public final class SynapseNotebookActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SynapseNotebook";

    /*
     * Execute Synapse notebook activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private SynapseNotebookActivityTypeProperties innerTypeProperties = new SynapseNotebookActivityTypeProperties();

    /**
     * Creates an instance of SynapseNotebookActivity class.
     */
    public SynapseNotebookActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Execute Synapse notebook activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private SynapseNotebookActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SynapseNotebookActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the notebook property: Synapse notebook reference.
     * 
     * @return the notebook value.
     */
    public SynapseNotebookReference notebook() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().notebook();
    }

    /**
     * Set the notebook property: Synapse notebook reference.
     * 
     * @param notebook the notebook value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withNotebook(SynapseNotebookReference notebook) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withNotebook(notebook);
        return this;
    }

    /**
     * Get the sparkPool property: The name of the big data pool which will be used to execute the notebook.
     * 
     * @return the sparkPool value.
     */
    public BigDataPoolParametrizationReference sparkPool() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkPool();
    }

    /**
     * Set the sparkPool property: The name of the big data pool which will be used to execute the notebook.
     * 
     * @param sparkPool the sparkPool value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withSparkPool(BigDataPoolParametrizationReference sparkPool) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkPool(sparkPool);
        return this;
    }

    /**
     * Get the parameters property: Notebook parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, NotebookParameter> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    /**
     * Set the parameters property: Notebook parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withParameters(Map<String, NotebookParameter> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the executorSize property: Number of core and memory to be used for executors allocated in the specified
     * Spark pool for the session, which will be used for overriding 'executorCores' and 'executorMemory' of the
     * notebook you provide. Type: string (or Expression with resultType string).
     * 
     * @return the executorSize value.
     */
    public Object executorSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().executorSize();
    }

    /**
     * Set the executorSize property: Number of core and memory to be used for executors allocated in the specified
     * Spark pool for the session, which will be used for overriding 'executorCores' and 'executorMemory' of the
     * notebook you provide. Type: string (or Expression with resultType string).
     * 
     * @param executorSize the executorSize value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withExecutorSize(Object executorSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withExecutorSize(executorSize);
        return this;
    }

    /**
     * Get the conf property: Spark configuration properties, which will override the 'conf' of the notebook you
     * provide.
     * 
     * @return the conf value.
     */
    public Object conf() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().conf();
    }

    /**
     * Set the conf property: Spark configuration properties, which will override the 'conf' of the notebook you
     * provide.
     * 
     * @param conf the conf value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withConf(Object conf) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withConf(conf);
        return this;
    }

    /**
     * Get the driverSize property: Number of core and memory to be used for driver allocated in the specified Spark
     * pool for the session, which will be used for overriding 'driverCores' and 'driverMemory' of the notebook you
     * provide. Type: string (or Expression with resultType string).
     * 
     * @return the driverSize value.
     */
    public Object driverSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().driverSize();
    }

    /**
     * Set the driverSize property: Number of core and memory to be used for driver allocated in the specified Spark
     * pool for the session, which will be used for overriding 'driverCores' and 'driverMemory' of the notebook you
     * provide. Type: string (or Expression with resultType string).
     * 
     * @param driverSize the driverSize value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withDriverSize(Object driverSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withDriverSize(driverSize);
        return this;
    }

    /**
     * Get the numExecutors property: Number of executors to launch for this session, which will override the
     * 'numExecutors' of the notebook you provide. Type: integer (or Expression with resultType integer).
     * 
     * @return the numExecutors value.
     */
    public Object numExecutors() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().numExecutors();
    }

    /**
     * Set the numExecutors property: Number of executors to launch for this session, which will override the
     * 'numExecutors' of the notebook you provide. Type: integer (or Expression with resultType integer).
     * 
     * @param numExecutors the numExecutors value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withNumExecutors(Object numExecutors) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withNumExecutors(numExecutors);
        return this;
    }

    /**
     * Get the configurationType property: The type of the spark config.
     * 
     * @return the configurationType value.
     */
    public ConfigurationType configurationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().configurationType();
    }

    /**
     * Set the configurationType property: The type of the spark config.
     * 
     * @param configurationType the configurationType value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withConfigurationType(ConfigurationType configurationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withConfigurationType(configurationType);
        return this;
    }

    /**
     * Get the targetSparkConfiguration property: The spark configuration of the spark job.
     * 
     * @return the targetSparkConfiguration value.
     */
    public SparkConfigurationParametrizationReference targetSparkConfiguration() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().targetSparkConfiguration();
    }

    /**
     * Set the targetSparkConfiguration property: The spark configuration of the spark job.
     * 
     * @param targetSparkConfiguration the targetSparkConfiguration value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity
        withTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withTargetSparkConfiguration(targetSparkConfiguration);
        return this;
    }

    /**
     * Get the sparkConfig property: Spark configuration property.
     * 
     * @return the sparkConfig value.
     */
    public Map<String, Object> sparkConfig() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkConfig();
    }

    /**
     * Set the sparkConfig property: Spark configuration property.
     * 
     * @param sparkConfig the sparkConfig value to set.
     * @return the SynapseNotebookActivity object itself.
     */
    public SynapseNotebookActivity withSparkConfig(Map<String, Object> sparkConfig) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkConfig(sparkConfig);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model SynapseNotebookActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookActivity.class);
}
