// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Synapse notebook reference type.
 */
@Fluent
public final class SynapseNotebookReference {
    /*
     * Synapse notebook reference type.
     */
    @JsonProperty(value = "type", required = true)
    private NotebookReferenceType type;

    /*
     * Reference notebook name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "referenceName", required = true)
    private Object referenceName;

    /**
     * Creates an instance of SynapseNotebookReference class.
     */
    public SynapseNotebookReference() {
    }

    /**
     * Get the type property: Synapse notebook reference type.
     * 
     * @return the type value.
     */
    public NotebookReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Synapse notebook reference type.
     * 
     * @param type the type value to set.
     * @return the SynapseNotebookReference object itself.
     */
    public SynapseNotebookReference withType(NotebookReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference notebook name. Type: string (or Expression with resultType string).
     * 
     * @return the referenceName value.
     */
    public Object referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference notebook name. Type: string (or Expression with resultType string).
     * 
     * @param referenceName the referenceName value to set.
     * @return the SynapseNotebookReference object itself.
     */
    public SynapseNotebookReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model SynapseNotebookReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model SynapseNotebookReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookReference.class);
}
