// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Synapse spark job reference type.
 */
@Fluent
public final class SynapseSparkJobReference {
    /*
     * Synapse spark job reference type.
     */
    @JsonProperty(value = "type", required = true)
    private SparkJobReferenceType type;

    /*
     * Reference spark job name. Expression with resultType string.
     */
    @JsonProperty(value = "referenceName", required = true)
    private Object referenceName;

    /**
     * Creates an instance of SynapseSparkJobReference class.
     */
    public SynapseSparkJobReference() {
    }

    /**
     * Get the type property: Synapse spark job reference type.
     * 
     * @return the type value.
     */
    public SparkJobReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Synapse spark job reference type.
     * 
     * @param type the type value to set.
     * @return the SynapseSparkJobReference object itself.
     */
    public SynapseSparkJobReference withType(SparkJobReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference spark job name. Expression with resultType string.
     * 
     * @return the referenceName value.
     */
    public Object referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference spark job name. Expression with resultType string.
     * 
     * @param referenceName the referenceName value to set.
     * @return the SynapseSparkJobReference object itself.
     */
    public SynapseSparkJobReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model SynapseSparkJobReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model SynapseSparkJobReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SynapseSparkJobReference.class);
}
