// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The data stored in text format.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = TextFormat.class, visible = true)
@JsonTypeName("TextFormat")
@Fluent
public final class TextFormat extends DatasetStorageFormat {
    /*
     * Type of dataset storage format.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "TextFormat";

    /*
     * The column delimiter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "columnDelimiter")
    private Object columnDelimiter;

    /*
     * The row delimiter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "rowDelimiter")
    private Object rowDelimiter;

    /*
     * The escape character. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "escapeChar")
    private Object escapeChar;

    /*
     * The quote character. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "quoteChar")
    private Object quoteChar;

    /*
     * The null value string. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "nullValue")
    private Object nullValue;

    /*
     * The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "encodingName")
    private Object encodingName;

    /*
     * Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "treatEmptyAsNull")
    private Object treatEmptyAsNull;

    /*
     * The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "skipLineCount")
    private Object skipLineCount;

    /*
     * When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "firstRowAsHeader")
    private Object firstRowAsHeader;

    /**
     * Creates an instance of TextFormat class.
     */
    public TextFormat() {
    }

    /**
     * Get the type property: Type of dataset storage format.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the columnDelimiter property: The column delimiter. Type: string (or Expression with resultType string).
     * 
     * @return the columnDelimiter value.
     */
    public Object columnDelimiter() {
        return this.columnDelimiter;
    }

    /**
     * Set the columnDelimiter property: The column delimiter. Type: string (or Expression with resultType string).
     * 
     * @param columnDelimiter the columnDelimiter value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withColumnDelimiter(Object columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        return this;
    }

    /**
     * Get the rowDelimiter property: The row delimiter. Type: string (or Expression with resultType string).
     * 
     * @return the rowDelimiter value.
     */
    public Object rowDelimiter() {
        return this.rowDelimiter;
    }

    /**
     * Set the rowDelimiter property: The row delimiter. Type: string (or Expression with resultType string).
     * 
     * @param rowDelimiter the rowDelimiter value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withRowDelimiter(Object rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
        return this;
    }

    /**
     * Get the escapeChar property: The escape character. Type: string (or Expression with resultType string).
     * 
     * @return the escapeChar value.
     */
    public Object escapeChar() {
        return this.escapeChar;
    }

    /**
     * Set the escapeChar property: The escape character. Type: string (or Expression with resultType string).
     * 
     * @param escapeChar the escapeChar value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withEscapeChar(Object escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    /**
     * Get the quoteChar property: The quote character. Type: string (or Expression with resultType string).
     * 
     * @return the quoteChar value.
     */
    public Object quoteChar() {
        return this.quoteChar;
    }

    /**
     * Set the quoteChar property: The quote character. Type: string (or Expression with resultType string).
     * 
     * @param quoteChar the quoteChar value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withQuoteChar(Object quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    /**
     * Get the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @return the nullValue value.
     */
    public Object nullValue() {
        return this.nullValue;
    }

    /**
     * Set the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @param nullValue the nullValue value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    /**
     * Get the encodingName property: The code page name of the preferred encoding. If miss, the default value is
     * ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the
     * following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type:
     * string (or Expression with resultType string).
     * 
     * @return the encodingName value.
     */
    public Object encodingName() {
        return this.encodingName;
    }

    /**
     * Set the encodingName property: The code page name of the preferred encoding. If miss, the default value is
     * ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the
     * following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type:
     * string (or Expression with resultType string).
     * 
     * @param encodingName the encodingName value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    /**
     * Get the treatEmptyAsNull property: Treat empty column values in the text file as null. The default value is true.
     * Type: boolean (or Expression with resultType boolean).
     * 
     * @return the treatEmptyAsNull value.
     */
    public Object treatEmptyAsNull() {
        return this.treatEmptyAsNull;
    }

    /**
     * Set the treatEmptyAsNull property: Treat empty column values in the text file as null. The default value is true.
     * Type: boolean (or Expression with resultType boolean).
     * 
     * @param treatEmptyAsNull the treatEmptyAsNull value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withTreatEmptyAsNull(Object treatEmptyAsNull) {
        this.treatEmptyAsNull = treatEmptyAsNull;
        return this;
    }

    /**
     * Get the skipLineCount property: The number of lines/rows to be skipped when parsing text files. The default value
     * is 0. Type: integer (or Expression with resultType integer).
     * 
     * @return the skipLineCount value.
     */
    public Object skipLineCount() {
        return this.skipLineCount;
    }

    /**
     * Set the skipLineCount property: The number of lines/rows to be skipped when parsing text files. The default value
     * is 0. Type: integer (or Expression with resultType integer).
     * 
     * @param skipLineCount the skipLineCount value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withSkipLineCount(Object skipLineCount) {
        this.skipLineCount = skipLineCount;
        return this;
    }

    /**
     * Get the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the firstRowAsHeader value.
     */
    public Object firstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    /**
     * Set the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param firstRowAsHeader the firstRowAsHeader value to set.
     * @return the TextFormat object itself.
     */
    public TextFormat withFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TextFormat withSerializer(Object serializer) {
        super.withSerializer(serializer);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TextFormat withDeserializer(Object deserializer) {
        super.withDeserializer(deserializer);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
