// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Pipeline that needs to be triggered with the given parameters.
 */
@Fluent
public final class TriggerPipelineReference {
    /*
     * Pipeline reference.
     */
    @JsonProperty(value = "pipelineReference")
    private PipelineReference pipelineReference;

    /*
     * Pipeline parameters.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> parameters;

    /**
     * Creates an instance of TriggerPipelineReference class.
     */
    public TriggerPipelineReference() {
    }

    /**
     * Get the pipelineReference property: Pipeline reference.
     * 
     * @return the pipelineReference value.
     */
    public PipelineReference pipelineReference() {
        return this.pipelineReference;
    }

    /**
     * Set the pipelineReference property: Pipeline reference.
     * 
     * @param pipelineReference the pipelineReference value to set.
     * @return the TriggerPipelineReference object itself.
     */
    public TriggerPipelineReference withPipelineReference(PipelineReference pipelineReference) {
        this.pipelineReference = pipelineReference;
        return this;
    }

    /**
     * Get the parameters property: Pipeline parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Pipeline parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the TriggerPipelineReference object itself.
     */
    public TriggerPipelineReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (pipelineReference() != null) {
            pipelineReference().validate();
        }
    }
}
