// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Trigger reference type.
 */
@Fluent
public final class TriggerReference {
    /*
     * Trigger reference type.
     */
    @JsonProperty(value = "type", required = true)
    private TriggerReferenceType type;

    /*
     * Reference trigger name.
     */
    @JsonProperty(value = "referenceName", required = true)
    private String referenceName;

    /**
     * Creates an instance of TriggerReference class.
     */
    public TriggerReference() {
    }

    /**
     * Get the type property: Trigger reference type.
     * 
     * @return the type value.
     */
    public TriggerReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Trigger reference type.
     * 
     * @param type the type value to set.
     * @return the TriggerReference object itself.
     */
    public TriggerReference withType(TriggerReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference trigger name.
     * 
     * @return the referenceName value.
     */
    public String referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference trigger name.
     * 
     * @param referenceName the referenceName value to set.
     * @return the TriggerReference object itself.
     */
    public TriggerReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model TriggerReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property referenceName in model TriggerReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TriggerReference.class);
}
