// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner;

/**
 * An immutable client-side representation of TriggerResource.
 */
public interface TriggerResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the properties property: Properties of the trigger.
     * 
     * @return the properties value.
     */
    Trigger properties();

    /**
     * Gets the name property: The resource name.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The resource type.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner object.
     * 
     * @return the inner object.
     */
    TriggerResourceInner innerModel();

    /**
     * The entirety of the TriggerResource definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithParentResource,
        DefinitionStages.WithProperties, DefinitionStages.WithCreate {
    }

    /**
     * The TriggerResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the TriggerResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the TriggerResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, factoryName.
             * 
             * @param resourceGroupName The resource group name.
             * @param factoryName The factory name.
             * @return the next definition stage.
             */
            WithProperties withExistingFactory(String resourceGroupName, String factoryName);
        }

        /**
         * The stage of the TriggerResource definition allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Properties of the trigger..
             * 
             * @param properties Properties of the trigger.
             * @return the next definition stage.
             */
            WithCreate withProperties(Trigger properties);
        }

        /**
         * The stage of the TriggerResource definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            TriggerResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            TriggerResource create(Context context);
        }

        /**
         * The stage of the TriggerResource definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the trigger entity. Should only be specified for update, for
             * which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the trigger entity. Should only be specified for update, for which it should match
             * existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the TriggerResource resource.
     * 
     * @return the stage of resource update.
     */
    TriggerResource.Update update();

    /**
     * The template for TriggerResource update.
     */
    interface Update extends UpdateStages.WithProperties, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        TriggerResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        TriggerResource apply(Context context);
    }

    /**
     * The TriggerResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the TriggerResource update allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Properties of the trigger..
             * 
             * @param properties Properties of the trigger.
             * @return the next definition stage.
             */
            Update withProperties(Trigger properties);
        }

        /**
         * The stage of the TriggerResource update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the trigger entity. Should only be specified for update, for
             * which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the trigger entity. Should only be specified for update, for which it should match
             * existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    TriggerResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    TriggerResource refresh(Context context);

    /**
     * Subscribe event trigger to events.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines the response of a trigger subscription operation.
     */
    TriggerSubscriptionOperationStatus subscribeToEvents();

    /**
     * Subscribe event trigger to events.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines the response of a trigger subscription operation.
     */
    TriggerSubscriptionOperationStatus subscribeToEvents(Context context);

    /**
     * Get a trigger's event subscription status.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trigger's event subscription status along with {@link Response}.
     */
    Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(Context context);

    /**
     * Get a trigger's event subscription status.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trigger's event subscription status.
     */
    TriggerSubscriptionOperationStatus getEventSubscriptionStatus();

    /**
     * Unsubscribe event trigger from events.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines the response of a trigger subscription operation.
     */
    TriggerSubscriptionOperationStatus unsubscribeFromEvents();

    /**
     * Unsubscribe event trigger from events.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines the response of a trigger subscription operation.
     */
    TriggerSubscriptionOperationStatus unsubscribeFromEvents(Context context);

    /**
     * Starts a trigger.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void start();

    /**
     * Starts a trigger.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void start(Context context);

    /**
     * Stops a trigger.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void stop();

    /**
     * Stops a trigger.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void stop(Context context);
}
