// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Trigger run status.
 */
public final class TriggerRunStatus extends ExpandableStringEnum<TriggerRunStatus> {
    /**
     * Static value Succeeded for TriggerRunStatus.
     */
    public static final TriggerRunStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for TriggerRunStatus.
     */
    public static final TriggerRunStatus FAILED = fromString("Failed");

    /**
     * Static value Inprogress for TriggerRunStatus.
     */
    public static final TriggerRunStatus INPROGRESS = fromString("Inprogress");

    /**
     * Creates a new instance of TriggerRunStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TriggerRunStatus() {
    }

    /**
     * Creates or finds a TriggerRunStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TriggerRunStatus.
     */
    @JsonCreator
    public static TriggerRunStatus fromString(String name) {
        return fromString(name, TriggerRunStatus.class);
    }

    /**
     * Gets known TriggerRunStatus values.
     * 
     * @return known TriggerRunStatus values.
     */
    public static Collection<TriggerRunStatus> values() {
        return values(TriggerRunStatus.class);
    }
}
