// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Enumerates possible state of Triggers.
 */
public final class TriggerRuntimeState extends ExpandableStringEnum<TriggerRuntimeState> {
    /**
     * Static value Started for TriggerRuntimeState.
     */
    public static final TriggerRuntimeState STARTED = fromString("Started");

    /**
     * Static value Stopped for TriggerRuntimeState.
     */
    public static final TriggerRuntimeState STOPPED = fromString("Stopped");

    /**
     * Static value Disabled for TriggerRuntimeState.
     */
    public static final TriggerRuntimeState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of TriggerRuntimeState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TriggerRuntimeState() {
    }

    /**
     * Creates or finds a TriggerRuntimeState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TriggerRuntimeState.
     */
    @JsonCreator
    public static TriggerRuntimeState fromString(String name) {
        return fromString(name, TriggerRuntimeState.class);
    }

    /**
     * Gets known TriggerRuntimeState values.
     * 
     * @return known TriggerRuntimeState values.
     */
    public static Collection<TriggerRuntimeState> values() {
        return values(TriggerRuntimeState.class);
    }
}
