// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.TumblingWindowTriggerTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Trigger that schedules pipeline runs for all fixed time interval windows from a start time without gaps and also
 * supports backfill scenarios (when start time is in the past).
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = TumblingWindowTrigger.class, visible = true)
@JsonTypeName("TumblingWindowTrigger")
@Fluent
public final class TumblingWindowTrigger extends Trigger {
    /*
     * Trigger type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "TumblingWindowTrigger";

    /*
     * Pipeline for which runs are created when an event is fired for trigger window that is ready.
     */
    @JsonProperty(value = "pipeline", required = true)
    private TriggerPipelineReference pipeline;

    /*
     * Tumbling Window Trigger properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private TumblingWindowTriggerTypeProperties innerTypeProperties = new TumblingWindowTriggerTypeProperties();

    /**
     * Creates an instance of TumblingWindowTrigger class.
     */
    public TumblingWindowTrigger() {
    }

    /**
     * Get the type property: Trigger type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the pipeline property: Pipeline for which runs are created when an event is fired for trigger window that is
     * ready.
     * 
     * @return the pipeline value.
     */
    public TriggerPipelineReference pipeline() {
        return this.pipeline;
    }

    /**
     * Set the pipeline property: Pipeline for which runs are created when an event is fired for trigger window that is
     * ready.
     * 
     * @param pipeline the pipeline value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    /**
     * Get the innerTypeProperties property: Tumbling Window Trigger properties.
     * 
     * @return the innerTypeProperties value.
     */
    private TumblingWindowTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TumblingWindowTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TumblingWindowTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the frequency property: The frequency of the time windows.
     * 
     * @return the frequency value.
     */
    public TumblingWindowFrequency frequency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().frequency();
    }

    /**
     * Set the frequency property: The frequency of the time windows.
     * 
     * @param frequency the frequency value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withFrequency(TumblingWindowFrequency frequency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withFrequency(frequency);
        return this;
    }

    /**
     * Get the interval property: The interval of the time windows. The minimum interval allowed is 15 Minutes.
     * 
     * @return the interval value.
     */
    public int interval() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().interval();
    }

    /**
     * Set the interval property: The interval of the time windows. The minimum interval allowed is 15 Minutes.
     * 
     * @param interval the interval value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withInterval(int interval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withInterval(interval);
        return this;
    }

    /**
     * Get the startTime property: The start time for the time period for the trigger during which events are fired for
     * windows that are ready. Only UTC time is currently supported.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().startTime();
    }

    /**
     * Set the startTime property: The start time for the time period for the trigger during which events are fired for
     * windows that are ready. Only UTC time is currently supported.
     * 
     * @param startTime the startTime value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withStartTime(OffsetDateTime startTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the endTime property: The end time for the time period for the trigger during which events are fired for
     * windows that are ready. Only UTC time is currently supported.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().endTime();
    }

    /**
     * Set the endTime property: The end time for the time period for the trigger during which events are fired for
     * windows that are ready. Only UTC time is currently supported.
     * 
     * @param endTime the endTime value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withEndTime(OffsetDateTime endTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withEndTime(endTime);
        return this;
    }

    /**
     * Get the delay property: Specifies how long the trigger waits past due time before triggering new run. It doesn't
     * alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern:
     * ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the delay value.
     */
    public Object delay() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().delay();
    }

    /**
     * Set the delay property: Specifies how long the trigger waits past due time before triggering new run. It doesn't
     * alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern:
     * ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param delay the delay value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withDelay(Object delay) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDelay(delay);
        return this;
    }

    /**
     * Get the maxConcurrency property: The max number of parallel time windows (ready for execution) for which a new
     * run is triggered.
     * 
     * @return the maxConcurrency value.
     */
    public int maxConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().maxConcurrency();
    }

    /**
     * Set the maxConcurrency property: The max number of parallel time windows (ready for execution) for which a new
     * run is triggered.
     * 
     * @param maxConcurrency the maxConcurrency value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withMaxConcurrency(int maxConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrency(maxConcurrency);
        return this;
    }

    /**
     * Get the retryPolicy property: Retry policy that will be applied for failed pipeline runs.
     * 
     * @return the retryPolicy value.
     */
    public RetryPolicy retryPolicy() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().retryPolicy();
    }

    /**
     * Set the retryPolicy property: Retry policy that will be applied for failed pipeline runs.
     * 
     * @param retryPolicy the retryPolicy value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRetryPolicy(retryPolicy);
        return this;
    }

    /**
     * Get the dependsOn property: Triggers that this trigger depends on. Only tumbling window triggers are supported.
     * 
     * @return the dependsOn value.
     */
    public List<DependencyReference> dependsOn() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dependsOn();
    }

    /**
     * Set the dependsOn property: Triggers that this trigger depends on. Only tumbling window triggers are supported.
     * 
     * @param dependsOn the dependsOn value to set.
     * @return the TumblingWindowTrigger object itself.
     */
    public TumblingWindowTrigger withDependsOn(List<DependencyReference> dependsOn) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDependsOn(dependsOn);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (pipeline() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property pipeline in model TumblingWindowTrigger"));
        } else {
            pipeline().validate();
        }
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model TumblingWindowTrigger"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTrigger.class);
}
