// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Update integration runtime node request.
 */
@Fluent
public final class UpdateIntegrationRuntimeNodeRequest {
    /*
     * The number of concurrent jobs permitted to run on the integration runtime node. Values between 1 and maxConcurrentJobs(inclusive) are allowed.
     */
    @JsonProperty(value = "concurrentJobsLimit")
    private Integer concurrentJobsLimit;

    /**
     * Creates an instance of UpdateIntegrationRuntimeNodeRequest class.
     */
    public UpdateIntegrationRuntimeNodeRequest() {
    }

    /**
     * Get the concurrentJobsLimit property: The number of concurrent jobs permitted to run on the integration runtime
     * node. Values between 1 and maxConcurrentJobs(inclusive) are allowed.
     * 
     * @return the concurrentJobsLimit value.
     */
    public Integer concurrentJobsLimit() {
        return this.concurrentJobsLimit;
    }

    /**
     * Set the concurrentJobsLimit property: The number of concurrent jobs permitted to run on the integration runtime
     * node. Values between 1 and maxConcurrentJobs(inclusive) are allowed.
     * 
     * @param concurrentJobsLimit the concurrentJobsLimit value to set.
     * @return the UpdateIntegrationRuntimeNodeRequest object itself.
     */
    public UpdateIntegrationRuntimeNodeRequest withConcurrentJobsLimit(Integer concurrentJobsLimit) {
        this.concurrentJobsLimit = concurrentJobsLimit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
