// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ValidationActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * This activity verifies that an external resource exists.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ValidationActivity.class, visible = true)
@JsonTypeName("Validation")
@Fluent
public final class ValidationActivity extends ControlActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Validation";

    /*
     * Validation activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ValidationActivityTypeProperties innerTypeProperties = new ValidationActivityTypeProperties();

    /**
     * Creates an instance of ValidationActivity class.
     */
    public ValidationActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Validation activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ValidationActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ValidationActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the timeout value.
     */
    public Object timeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().timeout();
    }

    /**
     * Set the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param timeout the timeout value to set.
     * @return the ValidationActivity object itself.
     */
    public ValidationActivity withTimeout(Object timeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withTimeout(timeout);
        return this;
    }

    /**
     * Get the sleep property: A delay in seconds between validation attempts. If no value is specified, 10 seconds will
     * be used as the default. Type: integer (or Expression with resultType integer).
     * 
     * @return the sleep value.
     */
    public Object sleep() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sleep();
    }

    /**
     * Set the sleep property: A delay in seconds between validation attempts. If no value is specified, 10 seconds will
     * be used as the default. Type: integer (or Expression with resultType integer).
     * 
     * @param sleep the sleep value to set.
     * @return the ValidationActivity object itself.
     */
    public ValidationActivity withSleep(Object sleep) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withSleep(sleep);
        return this;
    }

    /**
     * Get the minimumSize property: Can be used if dataset points to a file. The file must be greater than or equal in
     * size to the value specified. Type: integer (or Expression with resultType integer).
     * 
     * @return the minimumSize value.
     */
    public Object minimumSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minimumSize();
    }

    /**
     * Set the minimumSize property: Can be used if dataset points to a file. The file must be greater than or equal in
     * size to the value specified. Type: integer (or Expression with resultType integer).
     * 
     * @param minimumSize the minimumSize value to set.
     * @return the ValidationActivity object itself.
     */
    public ValidationActivity withMinimumSize(Object minimumSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withMinimumSize(minimumSize);
        return this;
    }

    /**
     * Get the childItems property: Can be used if dataset points to a folder. If set to true, the folder must have at
     * least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the childItems value.
     */
    public Object childItems() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().childItems();
    }

    /**
     * Set the childItems property: Can be used if dataset points to a folder. If set to true, the folder must have at
     * least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
     * 
     * @param childItems the childItems value to set.
     * @return the ValidationActivity object itself.
     */
    public ValidationActivity withChildItems(Object childItems) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withChildItems(childItems);
        return this;
    }

    /**
     * Get the dataset property: Validation activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    /**
     * Set the dataset property: Validation activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the ValidationActivity object itself.
     */
    public ValidationActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ValidationActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ValidationActivity.class);
}
