// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Definition of a single variable for a Pipeline.
 */
@Fluent
public final class VariableSpecification {
    /*
     * Variable type.
     */
    @JsonProperty(value = "type", required = true)
    private VariableType type;

    /*
     * Default value of variable.
     */
    @JsonProperty(value = "defaultValue")
    private Object defaultValue;

    /**
     * Creates an instance of VariableSpecification class.
     */
    public VariableSpecification() {
    }

    /**
     * Get the type property: Variable type.
     * 
     * @return the type value.
     */
    public VariableType type() {
        return this.type;
    }

    /**
     * Set the type property: Variable type.
     * 
     * @param type the type value to set.
     * @return the VariableSpecification object itself.
     */
    public VariableSpecification withType(VariableType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the defaultValue property: Default value of variable.
     * 
     * @return the defaultValue value.
     */
    public Object defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: Default value of variable.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the VariableSpecification object itself.
     */
    public VariableSpecification withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model VariableSpecification"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VariableSpecification.class);
}
