// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Variable type.
 */
public final class VariableType extends ExpandableStringEnum<VariableType> {
    /**
     * Static value String for VariableType.
     */
    public static final VariableType STRING = fromString("String");

    /**
     * Static value Bool for VariableType.
     */
    public static final VariableType BOOL = fromString("Bool");

    /**
     * Static value Array for VariableType.
     */
    public static final VariableType ARRAY = fromString("Array");

    /**
     * Creates a new instance of VariableType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VariableType() {
    }

    /**
     * Creates or finds a VariableType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VariableType.
     */
    @JsonCreator
    public static VariableType fromString(String name) {
        return fromString(name, VariableType.class);
    }

    /**
     * Gets known VariableType values.
     * 
     * @return known VariableType values.
     */
    public static Collection<VariableType> values() {
        return values(VariableType.class);
    }
}
