// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Web activity authentication properties.
 */
@Fluent
public final class WebActivityAuthentication {
    /*
     * Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal)
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
     */
    @JsonProperty(value = "pfx")
    private SecretBase pfx;

    /*
     * Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "username")
    private Object username;

    /*
     * Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "resource")
    private Object resource;

    /*
     * TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userTenant")
    private Object userTenant;

    /*
     * The credential reference containing authentication information.
     */
    @JsonProperty(value = "credential")
    private CredentialReference credential;

    /**
     * Creates an instance of WebActivityAuthentication class.
     */
    public WebActivityAuthentication() {
    }

    /**
     * Get the type property: Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal).
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal).
     * 
     * @param type the type value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the pfx property: Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal.
     * 
     * @return the pfx value.
     */
    public SecretBase pfx() {
        return this.pfx;
    }

    /**
     * Set the pfx property: Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal.
     * 
     * @param pfx the pfx value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    /**
     * Get the username property: Web activity authentication user name for basic authentication or ClientID when used
     * for ServicePrincipal. Type: string (or Expression with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: Web activity authentication user name for basic authentication or ClientID when used
     * for ServicePrincipal. Type: string (or Expression with resultType string).
     * 
     * @param username the username value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password for the PFX file or basic authentication / Secret when used for
     * ServicePrincipal.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password for the PFX file or basic authentication / Secret when used for
     * ServicePrincipal.
     * 
     * @param password the password value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the resource property: Resource for which Azure Auth token will be requested when using MSI Authentication.
     * Type: string (or Expression with resultType string).
     * 
     * @return the resource value.
     */
    public Object resource() {
        return this.resource;
    }

    /**
     * Set the resource property: Resource for which Azure Auth token will be requested when using MSI Authentication.
     * Type: string (or Expression with resultType string).
     * 
     * @param resource the resource value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withResource(Object resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the userTenant property: TenantId for which Azure Auth token will be requested when using ServicePrincipal
     * Authentication. Type: string (or Expression with resultType string).
     * 
     * @return the userTenant value.
     */
    public Object userTenant() {
        return this.userTenant;
    }

    /**
     * Set the userTenant property: TenantId for which Azure Auth token will be requested when using ServicePrincipal
     * Authentication. Type: string (or Expression with resultType string).
     * 
     * @param userTenant the userTenant value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withUserTenant(Object userTenant) {
        this.userTenant = userTenant;
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the WebActivityAuthentication object itself.
     */
    public WebActivityAuthentication withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (pfx() != null) {
            pfx().validate();
        }
        if (password() != null) {
            password().validate();
        }
        if (credential() != null) {
            credential().validate();
        }
    }
}
