// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A WebLinkedService that uses client certificate based authentication to communicate with an HTTP endpoint. This
 * scheme follows mutual authentication; the server must also provide valid credentials to the client.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "authenticationType",
    defaultImpl = WebClientCertificateAuthentication.class,
    visible = true)
@JsonTypeName("ClientCertificate")
@Fluent
public final class WebClientCertificateAuthentication extends WebLinkedServiceTypeProperties {
    /*
     * Type of authentication used to connect to the web table source.
     */
    @JsonTypeId
    @JsonProperty(value = "authenticationType", required = true)
    private WebAuthenticationType authenticationType = WebAuthenticationType.CLIENT_CERTIFICATE;

    /*
     * Base64-encoded contents of a PFX file.
     */
    @JsonProperty(value = "pfx", required = true)
    private SecretBase pfx;

    /*
     * Password for the PFX file.
     */
    @JsonProperty(value = "password", required = true)
    private SecretBase password;

    /**
     * Creates an instance of WebClientCertificateAuthentication class.
     */
    public WebClientCertificateAuthentication() {
    }

    /**
     * Get the authenticationType property: Type of authentication used to connect to the web table source.
     * 
     * @return the authenticationType value.
     */
    @Override
    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Get the pfx property: Base64-encoded contents of a PFX file.
     * 
     * @return the pfx value.
     */
    public SecretBase pfx() {
        return this.pfx;
    }

    /**
     * Set the pfx property: Base64-encoded contents of a PFX file.
     * 
     * @param pfx the pfx value to set.
     * @return the WebClientCertificateAuthentication object itself.
     */
    public WebClientCertificateAuthentication withPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    /**
     * Get the password property: Password for the PFX file.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password for the PFX file.
     * 
     * @param password the password value to set.
     * @return the WebClientCertificateAuthentication object itself.
     */
    public WebClientCertificateAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebClientCertificateAuthentication withUrl(Object url) {
        super.withUrl(url);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (pfx() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property pfx in model WebClientCertificateAuthentication"));
        } else {
            pfx().validate();
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property password in model WebClientCertificateAuthentication"));
        } else {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebClientCertificateAuthentication.class);
}
