// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Web linked service.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = WebLinkedService.class, visible = true)
@JsonTypeName("Web")
@Fluent
public final class WebLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Web";

    /*
     * Web linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private WebLinkedServiceTypeProperties typeProperties;

    /**
     * Creates an instance of WebLinkedService class.
     */
    public WebLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the typeProperties property: Web linked service properties.
     * 
     * @return the typeProperties value.
     */
    public WebLinkedServiceTypeProperties typeProperties() {
        return this.typeProperties;
    }

    /**
     * Set the typeProperties property: Web linked service properties.
     * 
     * @param typeProperties the typeProperties value to set.
     * @return the WebLinkedService object itself.
     */
    public WebLinkedService withTypeProperties(WebLinkedServiceTypeProperties typeProperties) {
        this.typeProperties = typeProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (typeProperties() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property typeProperties in model WebLinkedService"));
        } else {
            typeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebLinkedService.class);
}
