// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Base definition of WebLinkedServiceTypeProperties, this typeProperties is polymorphic based on authenticationType, so
 * not flattened in SDK models.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "authenticationType",
    defaultImpl = WebLinkedServiceTypeProperties.class,
    visible = true)
@JsonTypeName("WebLinkedServiceTypeProperties")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Anonymous", value = WebAnonymousAuthentication.class),
    @JsonSubTypes.Type(name = "Basic", value = WebBasicAuthentication.class),
    @JsonSubTypes.Type(name = "ClientCertificate", value = WebClientCertificateAuthentication.class) })
@Fluent
public class WebLinkedServiceTypeProperties {
    /*
     * Type of authentication used to connect to the web table source.
     */
    @JsonTypeId
    @JsonProperty(value = "authenticationType", required = true)
    private WebAuthenticationType authenticationType;

    /*
     * The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "url", required = true)
    private Object url;

    /**
     * Creates an instance of WebLinkedServiceTypeProperties class.
     */
    public WebLinkedServiceTypeProperties() {
        this.authenticationType = WebAuthenticationType.fromString("WebLinkedServiceTypeProperties");
    }

    /**
     * Get the authenticationType property: Type of authentication used to connect to the web table source.
     * 
     * @return the authenticationType value.
     */
    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Get the url property: The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or
     * Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.url;
    }

    /**
     * Set the url property: The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or
     * Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the WebLinkedServiceTypeProperties object itself.
     */
    public WebLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property url in model WebLinkedServiceTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebLinkedServiceTypeProperties.class);
}
