// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.DnsResourceReferencesClient;
import com.azure.resourcemanager.dns.fluent.RecordSetsClient;
import com.azure.resourcemanager.dns.fluent.ZonesClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

/** Initializes a new instance of the DnsManagementClientImpl type. */
@ServiceClient(builder = DnsManagementClientBuilder.class)
public final class DnsManagementClientImpl extends AzureServiceClient implements DnsManagementClient {
    private final ClientLogger logger = new ClientLogger(DnsManagementClientImpl.class);

    /** Specifies the Azure subscription ID, which uniquely identifies the Microsoft Azure subscription. */
    private final String subscriptionId;

    /**
     * Gets Specifies the Azure subscription ID, which uniquely identifies the Microsoft Azure subscription.
     *
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /** server parameter. */
    private final String endpoint;

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The default poll interval for long-running operation. */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /** The RecordSetsClient object to access its operations. */
    private final RecordSetsClient recordSets;

    /**
     * Gets the RecordSetsClient object to access its operations.
     *
     * @return the RecordSetsClient object.
     */
    public RecordSetsClient getRecordSets() {
        return this.recordSets;
    }

    /** The ZonesClient object to access its operations. */
    private final ZonesClient zones;

    /**
     * Gets the ZonesClient object to access its operations.
     *
     * @return the ZonesClient object.
     */
    public ZonesClient getZones() {
        return this.zones;
    }

    /** The DnsResourceReferencesClient object to access its operations. */
    private final DnsResourceReferencesClient dnsResourceReferences;

    /**
     * Gets the DnsResourceReferencesClient object to access its operations.
     *
     * @return the DnsResourceReferencesClient object.
     */
    public DnsResourceReferencesClient getDnsResourceReferences() {
        return this.dnsResourceReferences;
    }

    /**
     * Initializes an instance of DnsManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId Specifies the Azure subscription ID, which uniquely identifies the Microsoft Azure
     *     subscription.
     * @param endpoint server parameter.
     */
    DnsManagementClientImpl(
        HttpPipeline httpPipeline,
        SerializerAdapter serializerAdapter,
        Duration defaultPollInterval,
        AzureEnvironment environment,
        String subscriptionId,
        String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2018-05-01";
        this.recordSets = new RecordSetsClientImpl(this);
        this.zones = new ZonesClientImpl(this);
        this.dnsResourceReferences = new DnsResourceReferencesClientImpl(this);
    }
}
