// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.models.DnsResourceReference;
import java.io.IOException;
import java.util.List;

/**
 * Represents the properties of the Dns Resource Reference Result.
 */
@Fluent
public final class DnsResourceReferenceResultInner implements JsonSerializable<DnsResourceReferenceResultInner> {
    /*
     * The result of dns resource reference request. Returns a list of dns resource references for each of the azure
     * resource in the request.
     */
    private DnsResourceReferenceResultProperties innerProperties;

    /**
     * Creates an instance of DnsResourceReferenceResultInner class.
     */
    public DnsResourceReferenceResultInner() {
    }

    /**
     * Get the innerProperties property: The result of dns resource reference request. Returns a list of dns resource
     * references for each of the azure resource in the request.
     * 
     * @return the innerProperties value.
     */
    private DnsResourceReferenceResultProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the dnsResourceReferences property: The result of dns resource reference request. A list of dns resource
     * references for each of the azure resource in the request.
     * 
     * @return the dnsResourceReferences value.
     */
    public List<DnsResourceReference> dnsResourceReferences() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsResourceReferences();
    }

    /**
     * Set the dnsResourceReferences property: The result of dns resource reference request. A list of dns resource
     * references for each of the azure resource in the request.
     * 
     * @param dnsResourceReferences the dnsResourceReferences value to set.
     * @return the DnsResourceReferenceResultInner object itself.
     */
    public DnsResourceReferenceResultInner withDnsResourceReferences(List<DnsResourceReference> dnsResourceReferences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResourceReferenceResultProperties();
        }
        this.innerProperties().withDnsResourceReferences(dnsResourceReferences);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnsResourceReferenceResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnsResourceReferenceResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DnsResourceReferenceResultInner.
     */
    public static DnsResourceReferenceResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnsResourceReferenceResultInner deserializedDnsResourceReferenceResultInner
                = new DnsResourceReferenceResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedDnsResourceReferenceResultInner.innerProperties
                        = DnsResourceReferenceResultProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnsResourceReferenceResultInner;
        });
    }
}
