// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An NS record.
 */
@Fluent
public final class NsRecord implements JsonSerializable<NsRecord> {
    /*
     * The name server name for this NS record.
     */
    private String nsdname;

    /**
     * Creates an instance of NsRecord class.
     */
    public NsRecord() {
    }

    /**
     * Get the nsdname property: The name server name for this NS record.
     * 
     * @return the nsdname value.
     */
    public String nsdname() {
        return this.nsdname;
    }

    /**
     * Set the nsdname property: The name server name for this NS record.
     * 
     * @param nsdname the nsdname value to set.
     * @return the NsRecord object itself.
     */
    public NsRecord withNsdname(String nsdname) {
        this.nsdname = nsdname;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nsdname", this.nsdname);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NsRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NsRecord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the NsRecord.
     */
    public static NsRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NsRecord deserializedNsRecord = new NsRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nsdname".equals(fieldName)) {
                    deserializedNsRecord.nsdname = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNsRecord;
        });
    }
}
