// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An MX record.
 */
@Fluent
public final class MxRecord implements JsonSerializable<MxRecord> {
    /*
     * The preference value for this MX record.
     */
    private Integer preference;

    /*
     * The domain name of the mail host for this MX record.
     */
    private String exchange;

    /**
     * Creates an instance of MxRecord class.
     */
    public MxRecord() {
    }

    /**
     * Get the preference property: The preference value for this MX record.
     * 
     * @return the preference value.
     */
    public Integer preference() {
        return this.preference;
    }

    /**
     * Set the preference property: The preference value for this MX record.
     * 
     * @param preference the preference value to set.
     * @return the MxRecord object itself.
     */
    public MxRecord withPreference(Integer preference) {
        this.preference = preference;
        return this;
    }

    /**
     * Get the exchange property: The domain name of the mail host for this MX record.
     * 
     * @return the exchange value.
     */
    public String exchange() {
        return this.exchange;
    }

    /**
     * Set the exchange property: The domain name of the mail host for this MX record.
     * 
     * @param exchange the exchange value to set.
     * @return the MxRecord object itself.
     */
    public MxRecord withExchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("preference", this.preference);
        jsonWriter.writeStringField("exchange", this.exchange);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MxRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MxRecord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the MxRecord.
     */
    public static MxRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MxRecord deserializedMxRecord = new MxRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("preference".equals(fieldName)) {
                    deserializedMxRecord.preference = reader.getNullable(JsonReader::getInt);
                } else if ("exchange".equals(fieldName)) {
                    deserializedMxRecord.exchange = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMxRecord;
        });
    }
}
