/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.fluent.models.ZoneProperties;
import com.azure.resourcemanager.dns.models.ZoneType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ZoneInner
extends Resource {
    private String etag;
    private ZoneProperties innerProperties;
    private String id;
    private String name;
    private String type;

    public String etag() {
        return this.etag;
    }

    public ZoneInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private ZoneProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ZoneInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ZoneInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long maxNumberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfRecordSets();
    }

    public Long maxNumberOfRecordsPerRecordSet() {
        return this.innerProperties() == null ? null : this.innerProperties().maxNumberOfRecordsPerRecordSet();
    }

    public Long numberOfRecordSets() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfRecordSets();
    }

    public List<String> nameServers() {
        return this.innerProperties() == null ? null : this.innerProperties().nameServers();
    }

    public ZoneType zoneType() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneType();
    }

    public ZoneInner withZoneType(ZoneType zoneType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withZoneType(zoneType);
        return this;
    }

    public List<SubResource> registrationVirtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationVirtualNetworks();
    }

    public ZoneInner withRegistrationVirtualNetworks(List<SubResource> registrationVirtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withRegistrationVirtualNetworks(registrationVirtualNetworks);
        return this;
    }

    public List<SubResource> resolutionVirtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().resolutionVirtualNetworks();
    }

    public ZoneInner withResolutionVirtualNetworks(List<SubResource> resolutionVirtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ZoneProperties();
        }
        this.innerProperties().withResolutionVirtualNetworks(resolutionVirtualNetworks);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ZoneInner fromJson(JsonReader jsonReader) throws IOException {
        return (ZoneInner)((Object)jsonReader.readObject(reader -> {
            ZoneInner deserializedZoneInner = new ZoneInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedZoneInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedZoneInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedZoneInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedZoneInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedZoneInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedZoneInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedZoneInner.innerProperties = ZoneProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedZoneInner;
        }));
    }
}

