/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.EventGridManagementClient;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainsImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientBuilder;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ExtensionTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.OperationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicTypesImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicsImpl;
import com.azure.resourcemanager.eventgrid.models.DomainTopics;
import com.azure.resourcemanager.eventgrid.models.Domains;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.ExtensionTopics;
import com.azure.resourcemanager.eventgrid.models.Operations;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnections;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResources;
import com.azure.resourcemanager.eventgrid.models.SystemTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.SystemTopics;
import com.azure.resourcemanager.eventgrid.models.TopicTypes;
import com.azure.resourcemanager.eventgrid.models.Topics;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EventGridManager {
    private Domains domains;
    private DomainTopics domainTopics;
    private EventSubscriptions eventSubscriptions;
    private SystemTopicEventSubscriptions systemTopicEventSubscriptions;
    private Operations operations;
    private Topics topics;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private SystemTopics systemTopics;
    private ExtensionTopics extensionTopics;
    private TopicTypes topicTypes;
    private final EventGridManagementClient clientObject;

    private EventGridManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new EventGridManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return EventGridManager.configure().authenticate(credential, profile);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Domains domains() {
        if (this.domains == null) {
            this.domains = new DomainsImpl(this.clientObject.getDomains(), this);
        }
        return this.domains;
    }

    public DomainTopics domainTopics() {
        if (this.domainTopics == null) {
            this.domainTopics = new DomainTopicsImpl(this.clientObject.getDomainTopics(), this);
        }
        return this.domainTopics;
    }

    public EventSubscriptions eventSubscriptions() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new EventSubscriptionsImpl(this.clientObject.getEventSubscriptions(), this);
        }
        return this.eventSubscriptions;
    }

    public SystemTopicEventSubscriptions systemTopicEventSubscriptions() {
        if (this.systemTopicEventSubscriptions == null) {
            this.systemTopicEventSubscriptions = new SystemTopicEventSubscriptionsImpl(this.clientObject.getSystemTopicEventSubscriptions(), this);
        }
        return this.systemTopicEventSubscriptions;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Topics topics() {
        if (this.topics == null) {
            this.topics = new TopicsImpl(this.clientObject.getTopics(), this);
        }
        return this.topics;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public SystemTopics systemTopics() {
        if (this.systemTopics == null) {
            this.systemTopics = new SystemTopicsImpl(this.clientObject.getSystemTopics(), this);
        }
        return this.systemTopics;
    }

    public ExtensionTopics extensionTopics() {
        if (this.extensionTopics == null) {
            this.extensionTopics = new ExtensionTopicsImpl(this.clientObject.getExtensionTopics(), this);
        }
        return this.extensionTopics;
    }

    public TopicTypes topicTypes() {
        if (this.topicTypes == null) {
            this.topicTypes = new TopicTypesImpl(this.clientObject.getTopicTypes(), this);
        }
        return this.topicTypes;
    }

    public EventGridManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private final ClientLogger logger = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'retryPolicy' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'httpPipeline' cannot be negative"));
            }
            return this;
        }

        public EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.eventgrid").append("/").append("1.1.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new EventGridManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

