/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.DomainProvisioningState;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DomainProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DomainProperties.class);
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private DomainProvisioningState provisioningState;
    @JsonProperty(value="endpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String endpoint;
    @JsonProperty(value="inputSchema")
    private InputSchema inputSchema;
    @JsonProperty(value="inputSchemaMapping")
    private InputSchemaMapping inputSchemaMapping;
    @JsonProperty(value="metricResourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String metricResourceId;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="inboundIpRules")
    private List<InboundIpRule> inboundIpRules;
    @JsonProperty(value="disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="autoCreateTopicWithFirstSubscription")
    private Boolean autoCreateTopicWithFirstSubscription;
    @JsonProperty(value="autoDeleteTopicWithLastSubscription")
    private Boolean autoDeleteTopicWithLastSubscription;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public DomainProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public InputSchema inputSchema() {
        return this.inputSchema;
    }

    public DomainProperties withInputSchema(InputSchema inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public InputSchemaMapping inputSchemaMapping() {
        return this.inputSchemaMapping;
    }

    public DomainProperties withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        this.inputSchemaMapping = inputSchemaMapping;
        return this;
    }

    public String metricResourceId() {
        return this.metricResourceId;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DomainProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public DomainProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DomainProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean autoCreateTopicWithFirstSubscription() {
        return this.autoCreateTopicWithFirstSubscription;
    }

    public DomainProperties withAutoCreateTopicWithFirstSubscription(Boolean autoCreateTopicWithFirstSubscription) {
        this.autoCreateTopicWithFirstSubscription = autoCreateTopicWithFirstSubscription;
        return this;
    }

    public Boolean autoDeleteTopicWithLastSubscription() {
        return this.autoDeleteTopicWithLastSubscription;
    }

    public DomainProperties withAutoDeleteTopicWithLastSubscription(Boolean autoDeleteTopicWithLastSubscription) {
        this.autoDeleteTopicWithLastSubscription = autoDeleteTopicWithLastSubscription;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.inputSchemaMapping() != null) {
            this.inputSchemaMapping().validate();
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }
}

