/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventSubscriptionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventSubscriptionProperties.class);
    @JsonProperty(value="topic", access=JsonProperty.Access.WRITE_ONLY)
    private String topic;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private EventSubscriptionProvisioningState provisioningState;
    @JsonProperty(value="destination")
    private EventSubscriptionDestination destination;
    @JsonProperty(value="deliveryWithResourceIdentity")
    private DeliveryWithResourceIdentity deliveryWithResourceIdentity;
    @JsonProperty(value="filter")
    private EventSubscriptionFilter filter;
    @JsonProperty(value="labels")
    private List<String> labels;
    @JsonProperty(value="expirationTimeUtc")
    private OffsetDateTime expirationTimeUtc;
    @JsonProperty(value="eventDeliverySchema")
    private EventDeliverySchema eventDeliverySchema;
    @JsonProperty(value="retryPolicy")
    private RetryPolicy retryPolicy;
    @JsonProperty(value="deadLetterDestination")
    private DeadLetterDestination deadLetterDestination;
    @JsonProperty(value="deadLetterWithResourceIdentity")
    private DeadLetterWithResourceIdentity deadLetterWithResourceIdentity;

    public String topic() {
        return this.topic;
    }

    public EventSubscriptionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    public EventSubscriptionProperties withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.deliveryWithResourceIdentity;
    }

    public EventSubscriptionProperties withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        this.deliveryWithResourceIdentity = deliveryWithResourceIdentity;
        return this;
    }

    public EventSubscriptionFilter filter() {
        return this.filter;
    }

    public EventSubscriptionProperties withFilter(EventSubscriptionFilter filter) {
        this.filter = filter;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public EventSubscriptionProperties withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    public EventSubscriptionProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    public EventDeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    public EventSubscriptionProperties withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public EventSubscriptionProperties withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    public EventSubscriptionProperties withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.deadLetterWithResourceIdentity;
    }

    public EventSubscriptionProperties withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        this.deadLetterWithResourceIdentity = deadLetterWithResourceIdentity;
        return this;
    }

    public void validate() {
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.deliveryWithResourceIdentity() != null) {
            this.deliveryWithResourceIdentity().validate();
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
        if (this.retryPolicy() != null) {
            this.retryPolicy().validate();
        }
        if (this.deadLetterDestination() != null) {
            this.deadLetterDestination().validate();
        }
        if (this.deadLetterWithResourceIdentity() != null) {
            this.deadLetterWithResourceIdentity().validate();
        }
    }
}

