/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicProperties;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.ResourceProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class SystemTopicInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SystemTopicInner.class);
    @JsonProperty(value="properties")
    private SystemTopicProperties innerProperties;
    @JsonProperty(value="identity")
    private IdentityInfo identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private SystemTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public SystemTopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public SystemTopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SystemTopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ResourceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public SystemTopicInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public String topicType() {
        return this.innerProperties() == null ? null : this.innerProperties().topicType();
    }

    public SystemTopicInner withTopicType(String topicType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withTopicType(topicType);
        return this;
    }

    public String metricResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricResourceId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

