/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicProperties;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TopicProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class TopicInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TopicInner.class);
    @JsonProperty(value="properties")
    private TopicProperties innerProperties;
    @JsonProperty(value="identity")
    private IdentityInfo identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private TopicProperties innerProperties() {
        return this.innerProperties;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public TopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public TopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public TopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public TopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String endpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoint();
    }

    public InputSchema inputSchema() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchema();
    }

    public TopicInner withInputSchema(InputSchema inputSchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInputSchema(inputSchema);
        return this;
    }

    public InputSchemaMapping inputSchemaMapping() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchemaMapping();
    }

    public TopicInner withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInputSchemaMapping(inputSchemaMapping);
        return this;
    }

    public String metricResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricResourceId();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public TopicInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public TopicInner withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public TopicInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

