/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.DomainsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DomainInner;
import com.azure.resourcemanager.eventgrid.fluent.models.DomainSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.DomainImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainSharedAccessKeysImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.Domain;
import com.azure.resourcemanager.eventgrid.models.DomainRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.DomainSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.Domains;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class DomainsImpl
implements Domains {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DomainsImpl.class);
    private final DomainsClient innerClient;
    private final EventGridManager serviceManager;

    public DomainsImpl(DomainsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Domain getByResourceGroup(String resourceGroupName, String domainName) {
        DomainInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, domainName);
        if (inner != null) {
            return new DomainImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Domain> getByResourceGroupWithResponse(String resourceGroupName, String domainName, Context context) {
        Response<DomainInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, domainName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DomainImpl((DomainInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String domainName) {
        this.serviceClient().delete(resourceGroupName, domainName);
    }

    @Override
    public void delete(String resourceGroupName, String domainName, Context context) {
        this.serviceClient().delete(resourceGroupName, domainName, context);
    }

    @Override
    public PagedIterable<Domain> list() {
        PagedIterable<DomainInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new DomainImpl((DomainInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Domain> list(String filter, Integer top, Context context) {
        PagedIterable<DomainInner> inner = this.serviceClient().list(filter, top, context);
        return Utils.mapPage(inner, inner1 -> new DomainImpl((DomainInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Domain> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DomainInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new DomainImpl((DomainInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Domain> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<DomainInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return Utils.mapPage(inner, inner1 -> new DomainImpl((DomainInner)((Object)inner1), this.manager()));
    }

    @Override
    public DomainSharedAccessKeys listSharedAccessKeys(String resourceGroupName, String domainName) {
        DomainSharedAccessKeysInner inner = this.serviceClient().listSharedAccessKeys(resourceGroupName, domainName);
        if (inner != null) {
            return new DomainSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DomainSharedAccessKeys> listSharedAccessKeysWithResponse(String resourceGroupName, String domainName, Context context) {
        Response<DomainSharedAccessKeysInner> inner = this.serviceClient().listSharedAccessKeysWithResponse(resourceGroupName, domainName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DomainSharedAccessKeysImpl((DomainSharedAccessKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DomainSharedAccessKeys regenerateKey(String resourceGroupName, String domainName, DomainRegenerateKeyRequest regenerateKeyRequest) {
        DomainSharedAccessKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, domainName, regenerateKeyRequest);
        if (inner != null) {
            return new DomainSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DomainSharedAccessKeys> regenerateKeyWithResponse(String resourceGroupName, String domainName, DomainRegenerateKeyRequest regenerateKeyRequest, Context context) {
        Response<DomainSharedAccessKeysInner> inner = this.serviceClient().regenerateKeyWithResponse(resourceGroupName, domainName, regenerateKeyRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DomainSharedAccessKeysImpl((DomainSharedAccessKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Domain getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String domainName = Utils.getValueFromIdByName(id, "domains");
        if (domainName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'domains'.", id)));
        }
        return (Domain)this.getByResourceGroupWithResponse(resourceGroupName, domainName, Context.NONE).getValue();
    }

    @Override
    public Response<Domain> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String domainName = Utils.getValueFromIdByName(id, "domains");
        if (domainName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'domains'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, domainName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String domainName = Utils.getValueFromIdByName(id, "domains");
        if (domainName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'domains'.", id)));
        }
        this.delete(resourceGroupName, domainName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String domainName = Utils.getValueFromIdByName(id, "domains");
        if (domainName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'domains'.", id)));
        }
        this.delete(resourceGroupName, domainName, context);
    }

    private DomainsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public DomainImpl define(String name) {
        return new DomainImpl(name, this.manager());
    }
}

