/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={EventGridManagementClientImpl.class})
public final class EventGridManagementClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private Duration defaultPollInterval;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public EventGridManagementClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public EventGridManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public EventGridManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public EventGridManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public EventGridManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public EventGridManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public EventGridManagementClientImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://management.azure.com";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        EventGridManagementClientImpl client = new EventGridManagementClientImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.subscriptionId, this.endpoint);
        return client;
    }
}

