/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.ExtensionTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ExtensionTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ExtensionTopicsClientImpl
implements ExtensionTopicsClient {
    private final ClientLogger logger = new ClientLogger(ExtensionTopicsClientImpl.class);
    private final ExtensionTopicsService service;
    private final EventGridManagementClientImpl client;

    ExtensionTopicsClientImpl(EventGridManagementClientImpl client) {
        this.service = (ExtensionTopicsService)RestProxy.create(ExtensionTopicsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExtensionTopicInner>> getWithResponseAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExtensionTopicInner>> getWithResponseAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExtensionTopicInner> getAsync(String scope) {
        return this.getWithResponseAsync(scope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ExtensionTopicInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExtensionTopicInner get(String scope) {
        return (ExtensionTopicInner)((Object)this.getAsync(scope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExtensionTopicInner> getWithResponse(String scope, Context context) {
        return (Response)this.getWithResponseAsync(scope, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementC")
    private static interface ExtensionTopicsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.EventGrid/extensionTopics/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExtensionTopicInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

