/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.ExtensionTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ExtensionTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.ExtensionTopicImpl;
import com.azure.resourcemanager.eventgrid.models.ExtensionTopic;
import com.azure.resourcemanager.eventgrid.models.ExtensionTopics;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ExtensionTopicsImpl
implements ExtensionTopics {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExtensionTopicsImpl.class);
    private final ExtensionTopicsClient innerClient;
    private final EventGridManager serviceManager;

    public ExtensionTopicsImpl(ExtensionTopicsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ExtensionTopic get(String scope) {
        ExtensionTopicInner inner = this.serviceClient().get(scope);
        if (inner != null) {
            return new ExtensionTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ExtensionTopic> getWithResponse(String scope, Context context) {
        Response<ExtensionTopicInner> inner = this.serviceClient().getWithResponse(scope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExtensionTopicImpl((ExtensionTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    private ExtensionTopicsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

