/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.OperationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.OperationInner;
import com.azure.resourcemanager.eventgrid.implementation.OperationImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.Operation;
import com.azure.resourcemanager.eventgrid.models.Operations;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class OperationsImpl
implements Operations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final EventGridManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Operation> list() {
        PagedIterable<OperationInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Operation> list(Context context) {
        PagedIterable<OperationInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

