/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnections;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnectionsParentType;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class PrivateEndpointConnectionsImpl
implements PrivateEndpointConnections {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionsImpl.class);
    private final PrivateEndpointConnectionsClient innerClient;
    private final EventGridManager serviceManager;

    public PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PrivateEndpointConnection get(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner inner = this.serviceClient().get(resourceGroupName, parentType, parentName, privateEndpointConnectionName);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PrivateEndpointConnection> getWithResponse(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName, Context context) {
        Response<PrivateEndpointConnectionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, parentType, parentName, privateEndpointConnectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateEndpointConnection update(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection) {
        PrivateEndpointConnectionInner inner = this.serviceClient().update(resourceGroupName, parentType, parentName, privateEndpointConnectionName, privateEndpointConnection);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PrivateEndpointConnection update(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName, PrivateEndpointConnectionInner privateEndpointConnection, Context context) {
        PrivateEndpointConnectionInner inner = this.serviceClient().update(resourceGroupName, parentType, parentName, privateEndpointConnectionName, privateEndpointConnection, context);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName) {
        this.serviceClient().delete(resourceGroupName, parentType, parentName, privateEndpointConnectionName);
    }

    @Override
    public void delete(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String privateEndpointConnectionName, Context context) {
        this.serviceClient().delete(resourceGroupName, parentType, parentName, privateEndpointConnectionName, context);
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByResource(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByResource(resourceGroupName, parentType, parentName);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByResource(String resourceGroupName, PrivateEndpointConnectionsParentType parentType, String parentName, String filter, Integer top, Context context) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByResource(resourceGroupName, parentType, parentName, filter, top, context);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    private PrivateEndpointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

