/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.SystemTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.DeliveryAttributeListResultImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionFullUrlImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.EventSubscription;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.SystemTopicEventSubscriptions;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class SystemTopicEventSubscriptionsImpl
implements SystemTopicEventSubscriptions {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SystemTopicEventSubscriptionsImpl.class);
    private final SystemTopicEventSubscriptionsClient innerClient;
    private final EventGridManager serviceManager;

    public SystemTopicEventSubscriptionsImpl(SystemTopicEventSubscriptionsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public EventSubscription get(String resourceGroupName, String systemTopicName, String eventSubscriptionName) {
        EventSubscriptionInner inner = this.serviceClient().get(resourceGroupName, systemTopicName, eventSubscriptionName);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<EventSubscription> getWithResponse(String resourceGroupName, String systemTopicName, String eventSubscriptionName, Context context) {
        Response<EventSubscriptionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, systemTopicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public EventSubscription createOrUpdate(String resourceGroupName, String systemTopicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        EventSubscriptionInner inner = this.serviceClient().createOrUpdate(resourceGroupName, systemTopicName, eventSubscriptionName, eventSubscriptionInfo);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscription createOrUpdate(String resourceGroupName, String systemTopicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        EventSubscriptionInner inner = this.serviceClient().createOrUpdate(resourceGroupName, systemTopicName, eventSubscriptionName, eventSubscriptionInfo, context);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String systemTopicName, String eventSubscriptionName) {
        this.serviceClient().delete(resourceGroupName, systemTopicName, eventSubscriptionName);
    }

    @Override
    public void delete(String resourceGroupName, String systemTopicName, String eventSubscriptionName, Context context) {
        this.serviceClient().delete(resourceGroupName, systemTopicName, eventSubscriptionName, context);
    }

    @Override
    public EventSubscription update(String resourceGroupName, String systemTopicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        EventSubscriptionInner inner = this.serviceClient().update(resourceGroupName, systemTopicName, eventSubscriptionName, eventSubscriptionUpdateParameters);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscription update(String resourceGroupName, String systemTopicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        EventSubscriptionInner inner = this.serviceClient().update(resourceGroupName, systemTopicName, eventSubscriptionName, eventSubscriptionUpdateParameters, context);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscriptionFullUrl getFullUrl(String resourceGroupName, String systemTopicName, String eventSubscriptionName) {
        EventSubscriptionFullUrlInner inner = this.serviceClient().getFullUrl(resourceGroupName, systemTopicName, eventSubscriptionName);
        if (inner != null) {
            return new EventSubscriptionFullUrlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(String resourceGroupName, String systemTopicName, String eventSubscriptionName, Context context) {
        Response<EventSubscriptionFullUrlInner> inner = this.serviceClient().getFullUrlWithResponse(resourceGroupName, systemTopicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventSubscriptionFullUrlImpl((EventSubscriptionFullUrlInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<EventSubscription> listBySystemTopic(String resourceGroupName, String systemTopicName) {
        PagedIterable<EventSubscriptionInner> inner = this.serviceClient().listBySystemTopic(resourceGroupName, systemTopicName);
        return Utils.mapPage(inner, inner1 -> new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<EventSubscription> listBySystemTopic(String resourceGroupName, String systemTopicName, String filter, Integer top, Context context) {
        PagedIterable<EventSubscriptionInner> inner = this.serviceClient().listBySystemTopic(resourceGroupName, systemTopicName, filter, top, context);
        return Utils.mapPage(inner, inner1 -> new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public DeliveryAttributeListResult getDeliveryAttributes(String resourceGroupName, String systemTopicName, String eventSubscriptionName) {
        DeliveryAttributeListResultInner inner = this.serviceClient().getDeliveryAttributes(resourceGroupName, systemTopicName, eventSubscriptionName);
        if (inner != null) {
            return new DeliveryAttributeListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(String resourceGroupName, String systemTopicName, String eventSubscriptionName, Context context) {
        Response<DeliveryAttributeListResultInner> inner = this.serviceClient().getDeliveryAttributesWithResponse(resourceGroupName, systemTopicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeliveryAttributeListResultImpl((DeliveryAttributeListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private SystemTopicEventSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

