/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.ResourceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.SystemTopic;
import com.azure.resourcemanager.eventgrid.models.SystemTopicUpdateParameters;
import java.util.Collections;
import java.util.Map;

public final class SystemTopicImpl
implements SystemTopic,
SystemTopic.Definition,
SystemTopic.Update {
    private SystemTopicInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String systemTopicName;
    private SystemTopicUpdateParameters updateSystemTopicUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public IdentityInfo identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ResourceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String source() {
        return this.innerModel().source();
    }

    @Override
    public String topicType() {
        return this.innerModel().topicType();
    }

    @Override
    public String metricResourceId() {
        return this.innerModel().metricResourceId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public SystemTopicInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public SystemTopicImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SystemTopic create() {
        this.innerObject = this.serviceManager.serviceClient().getSystemTopics().createOrUpdate(this.resourceGroupName, this.systemTopicName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SystemTopic create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSystemTopics().createOrUpdate(this.resourceGroupName, this.systemTopicName, this.innerModel(), context);
        return this;
    }

    SystemTopicImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new SystemTopicInner();
        this.serviceManager = serviceManager;
        this.systemTopicName = name;
    }

    @Override
    public SystemTopicImpl update() {
        this.updateSystemTopicUpdateParameters = new SystemTopicUpdateParameters();
        return this;
    }

    @Override
    public SystemTopic apply() {
        this.innerObject = this.serviceManager.serviceClient().getSystemTopics().update(this.resourceGroupName, this.systemTopicName, this.updateSystemTopicUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public SystemTopic apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSystemTopics().update(this.resourceGroupName, this.systemTopicName, this.updateSystemTopicUpdateParameters, context);
        return this;
    }

    SystemTopicImpl(SystemTopicInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.systemTopicName = Utils.getValueFromIdByName(innerObject.id(), "systemTopics");
    }

    @Override
    public SystemTopic refresh() {
        this.innerObject = (SystemTopicInner)((Object)this.serviceManager.serviceClient().getSystemTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.systemTopicName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SystemTopic refresh(Context context) {
        this.innerObject = (SystemTopicInner)((Object)this.serviceManager.serviceClient().getSystemTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.systemTopicName, context).getValue());
        return this;
    }

    @Override
    public SystemTopicImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SystemTopicImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SystemTopicImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateSystemTopicUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public SystemTopicImpl withIdentity(IdentityInfo identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateSystemTopicUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public SystemTopicImpl withSource(String source) {
        this.innerModel().withSource(source);
        return this;
    }

    @Override
    public SystemTopicImpl withTopicType(String topicType) {
        this.innerModel().withTopicType(topicType);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

