/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.Topic;
import com.azure.resourcemanager.eventgrid.models.TopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.TopicUpdateParameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class TopicImpl
implements Topic,
Topic.Definition,
Topic.Update {
    private TopicInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String topicName;
    private TopicUpdateParameters updateTopicUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public IdentityInfo identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public TopicProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String endpoint() {
        return this.innerModel().endpoint();
    }

    @Override
    public InputSchema inputSchema() {
        return this.innerModel().inputSchema();
    }

    @Override
    public InputSchemaMapping inputSchemaMapping() {
        return this.innerModel().inputSchemaMapping();
    }

    @Override
    public String metricResourceId() {
        return this.innerModel().metricResourceId();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<InboundIpRule> inboundIpRules() {
        List<InboundIpRule> inner = this.innerModel().inboundIpRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public TopicInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public TopicImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Topic create() {
        this.innerObject = this.serviceManager.serviceClient().getTopics().createOrUpdate(this.resourceGroupName, this.topicName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Topic create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTopics().createOrUpdate(this.resourceGroupName, this.topicName, this.innerModel(), context);
        return this;
    }

    TopicImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new TopicInner();
        this.serviceManager = serviceManager;
        this.topicName = name;
    }

    @Override
    public TopicImpl update() {
        this.updateTopicUpdateParameters = new TopicUpdateParameters();
        return this;
    }

    @Override
    public Topic apply() {
        this.innerObject = this.serviceManager.serviceClient().getTopics().update(this.resourceGroupName, this.topicName, this.updateTopicUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Topic apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTopics().update(this.resourceGroupName, this.topicName, this.updateTopicUpdateParameters, context);
        return this;
    }

    TopicImpl(TopicInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.topicName = Utils.getValueFromIdByName(innerObject.id(), "topics");
    }

    @Override
    public Topic refresh() {
        this.innerObject = (TopicInner)((Object)this.serviceManager.serviceClient().getTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.topicName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Topic refresh(Context context) {
        this.innerObject = (TopicInner)((Object)this.serviceManager.serviceClient().getTopics().getByResourceGroupWithResponse(this.resourceGroupName, this.topicName, context).getValue());
        return this;
    }

    @Override
    public TopicSharedAccessKeys listSharedAccessKeys() {
        return this.serviceManager.topics().listSharedAccessKeys(this.resourceGroupName, this.topicName);
    }

    @Override
    public Response<TopicSharedAccessKeys> listSharedAccessKeysWithResponse(Context context) {
        return this.serviceManager.topics().listSharedAccessKeysWithResponse(this.resourceGroupName, this.topicName, context);
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.serviceManager.topics().regenerateKey(this.resourceGroupName, this.topicName, regenerateKeyRequest);
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.serviceManager.topics().regenerateKey(this.resourceGroupName, this.topicName, regenerateKeyRequest, context);
    }

    @Override
    public TopicImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public TopicImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public TopicImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateTopicUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public TopicImpl withIdentity(IdentityInfo identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateTopicUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public TopicImpl withInputSchema(InputSchema inputSchema) {
        this.innerModel().withInputSchema(inputSchema);
        return this;
    }

    @Override
    public TopicImpl withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        this.innerModel().withInputSchemaMapping(inputSchemaMapping);
        return this;
    }

    @Override
    public TopicImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateTopicUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public TopicImpl withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.isInCreateMode()) {
            this.innerModel().withInboundIpRules(inboundIpRules);
            return this;
        }
        this.updateTopicUpdateParameters.withInboundIpRules(inboundIpRules);
        return this;
    }

    @Override
    public TopicImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisableLocalAuth(disableLocalAuth);
            return this;
        }
        this.updateTopicUpdateParameters.withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

