/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.TopicTypesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicTypeInfoInner;
import com.azure.resourcemanager.eventgrid.implementation.EventTypeImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicTypeInfoImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.EventType;
import com.azure.resourcemanager.eventgrid.models.TopicTypeInfo;
import com.azure.resourcemanager.eventgrid.models.TopicTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class TopicTypesImpl
implements TopicTypes {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TopicTypesImpl.class);
    private final TopicTypesClient innerClient;
    private final EventGridManager serviceManager;

    public TopicTypesImpl(TopicTypesClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TopicTypeInfo> list() {
        PagedIterable<TopicTypeInfoInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new TopicTypeInfoImpl((TopicTypeInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TopicTypeInfo> list(Context context) {
        PagedIterable<TopicTypeInfoInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new TopicTypeInfoImpl((TopicTypeInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public TopicTypeInfo get(String topicTypeName) {
        TopicTypeInfoInner inner = this.serviceClient().get(topicTypeName);
        if (inner != null) {
            return new TopicTypeInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TopicTypeInfo> getWithResponse(String topicTypeName, Context context) {
        Response<TopicTypeInfoInner> inner = this.serviceClient().getWithResponse(topicTypeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TopicTypeInfoImpl((TopicTypeInfoInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<EventType> listEventTypes(String topicTypeName) {
        PagedIterable<EventTypeInner> inner = this.serviceClient().listEventTypes(topicTypeName);
        return Utils.mapPage(inner, inner1 -> new EventTypeImpl((EventTypeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<EventType> listEventTypes(String topicTypeName, Context context) {
        PagedIterable<EventTypeInner> inner = this.serviceClient().listEventTypes(topicTypeName, context);
        return Utils.mapPage(inner, inner1 -> new EventTypeImpl((EventTypeInner)((Object)inner1), this.manager()));
    }

    private TopicTypesClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

