/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.TopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.EventTypeImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicSharedAccessKeysImpl;
import com.azure.resourcemanager.eventgrid.implementation.Utils;
import com.azure.resourcemanager.eventgrid.models.EventType;
import com.azure.resourcemanager.eventgrid.models.Topic;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.Topics;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class TopicsImpl
implements Topics {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TopicsImpl.class);
    private final TopicsClient innerClient;
    private final EventGridManager serviceManager;

    public TopicsImpl(TopicsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Topic getByResourceGroup(String resourceGroupName, String topicName) {
        TopicInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, topicName);
        if (inner != null) {
            return new TopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Topic> getByResourceGroupWithResponse(String resourceGroupName, String topicName, Context context) {
        Response<TopicInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, topicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TopicImpl((TopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String topicName) {
        this.serviceClient().delete(resourceGroupName, topicName);
    }

    @Override
    public void delete(String resourceGroupName, String topicName, Context context) {
        this.serviceClient().delete(resourceGroupName, topicName, context);
    }

    @Override
    public PagedIterable<Topic> list() {
        PagedIterable<TopicInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new TopicImpl((TopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Topic> list(String filter, Integer top, Context context) {
        PagedIterable<TopicInner> inner = this.serviceClient().list(filter, top, context);
        return Utils.mapPage(inner, inner1 -> new TopicImpl((TopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Topic> listByResourceGroup(String resourceGroupName) {
        PagedIterable<TopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new TopicImpl((TopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Topic> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<TopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return Utils.mapPage(inner, inner1 -> new TopicImpl((TopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public TopicSharedAccessKeys listSharedAccessKeys(String resourceGroupName, String topicName) {
        TopicSharedAccessKeysInner inner = this.serviceClient().listSharedAccessKeys(resourceGroupName, topicName);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TopicSharedAccessKeys> listSharedAccessKeysWithResponse(String resourceGroupName, String topicName, Context context) {
        Response<TopicSharedAccessKeysInner> inner = this.serviceClient().listSharedAccessKeysWithResponse(resourceGroupName, topicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TopicSharedAccessKeysImpl((TopicSharedAccessKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        TopicSharedAccessKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, topicName, regenerateKeyRequest);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        TopicSharedAccessKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, topicName, regenerateKeyRequest, context);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<EventType> listEventTypes(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        PagedIterable<EventTypeInner> inner = this.serviceClient().listEventTypes(resourceGroupName, providerNamespace, resourceTypeName, resourceName);
        return Utils.mapPage(inner, inner1 -> new EventTypeImpl((EventTypeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<EventType> listEventTypes(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, Context context) {
        PagedIterable<EventTypeInner> inner = this.serviceClient().listEventTypes(resourceGroupName, providerNamespace, resourceTypeName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new EventTypeImpl((EventTypeInner)((Object)inner1), this.manager()));
    }

    @Override
    public Topic getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String topicName = Utils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        return (Topic)this.getByResourceGroupWithResponse(resourceGroupName, topicName, Context.NONE).getValue();
    }

    @Override
    public Response<Topic> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String topicName = Utils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, topicName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String topicName = Utils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        this.delete(resourceGroupName, topicName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String topicName = Utils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        this.delete(resourceGroupName, topicName, context);
    }

    private TopicsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public TopicImpl define(String name) {
        return new TopicImpl(name, this.manager());
    }
}

