/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.models.DomainUpdateParameterProperties;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class DomainUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DomainUpdateParameters.class);
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties")
    private DomainUpdateParameterProperties innerProperties;
    @JsonProperty(value="identity")
    private IdentityInfo identity;

    public Map<String, String> tags() {
        return this.tags;
    }

    public DomainUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private DomainUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public DomainUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public DomainUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainUpdateParameterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public DomainUpdateParameters withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainUpdateParameterProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public DomainUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainUpdateParameterProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public Boolean autoCreateTopicWithFirstSubscription() {
        return this.innerProperties() == null ? null : this.innerProperties().autoCreateTopicWithFirstSubscription();
    }

    public DomainUpdateParameters withAutoCreateTopicWithFirstSubscription(Boolean autoCreateTopicWithFirstSubscription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainUpdateParameterProperties();
        }
        this.innerProperties().withAutoCreateTopicWithFirstSubscription(autoCreateTopicWithFirstSubscription);
        return this;
    }

    public Boolean autoDeleteTopicWithLastSubscription() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDeleteTopicWithLastSubscription();
    }

    public DomainUpdateParameters withAutoDeleteTopicWithLastSubscription(Boolean autoDeleteTopicWithLastSubscription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainUpdateParameterProperties();
        }
        this.innerProperties().withAutoDeleteTopicWithLastSubscription(autoDeleteTopicWithLastSubscription);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

