/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class EventSubscriptionFilter {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventSubscriptionFilter.class);
    @JsonProperty(value="subjectBeginsWith")
    private String subjectBeginsWith;
    @JsonProperty(value="subjectEndsWith")
    private String subjectEndsWith;
    @JsonProperty(value="includedEventTypes")
    private List<String> includedEventTypes;
    @JsonProperty(value="isSubjectCaseSensitive")
    private Boolean isSubjectCaseSensitive;
    @JsonProperty(value="enableAdvancedFilteringOnArrays")
    private Boolean enableAdvancedFilteringOnArrays;
    @JsonProperty(value="advancedFilters")
    private List<AdvancedFilter> advancedFilters;

    public String subjectBeginsWith() {
        return this.subjectBeginsWith;
    }

    public EventSubscriptionFilter withSubjectBeginsWith(String subjectBeginsWith) {
        this.subjectBeginsWith = subjectBeginsWith;
        return this;
    }

    public String subjectEndsWith() {
        return this.subjectEndsWith;
    }

    public EventSubscriptionFilter withSubjectEndsWith(String subjectEndsWith) {
        this.subjectEndsWith = subjectEndsWith;
        return this;
    }

    public List<String> includedEventTypes() {
        return this.includedEventTypes;
    }

    public EventSubscriptionFilter withIncludedEventTypes(List<String> includedEventTypes) {
        this.includedEventTypes = includedEventTypes;
        return this;
    }

    public Boolean isSubjectCaseSensitive() {
        return this.isSubjectCaseSensitive;
    }

    public EventSubscriptionFilter withIsSubjectCaseSensitive(Boolean isSubjectCaseSensitive) {
        this.isSubjectCaseSensitive = isSubjectCaseSensitive;
        return this;
    }

    public Boolean enableAdvancedFilteringOnArrays() {
        return this.enableAdvancedFilteringOnArrays;
    }

    public EventSubscriptionFilter withEnableAdvancedFilteringOnArrays(Boolean enableAdvancedFilteringOnArrays) {
        this.enableAdvancedFilteringOnArrays = enableAdvancedFilteringOnArrays;
        return this;
    }

    public List<AdvancedFilter> advancedFilters() {
        return this.advancedFilters;
    }

    public EventSubscriptionFilter withAdvancedFilters(List<AdvancedFilter> advancedFilters) {
        this.advancedFilters = advancedFilters;
        return this;
    }

    public void validate() {
        if (this.advancedFilters() != null) {
            this.advancedFilters().forEach(e -> e.validate());
        }
    }
}

