/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.models.IdentityType;
import com.azure.resourcemanager.eventgrid.models.UserIdentityProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class IdentityInfo {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IdentityInfo.class);
    @JsonProperty(value="type")
    private IdentityType type;
    @JsonProperty(value="principalId")
    private String principalId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, UserIdentityProperties> userAssignedIdentities;

    public IdentityType type() {
        return this.type;
    }

    public IdentityInfo withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public IdentityInfo withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public IdentityInfo withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public IdentityInfo withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

