/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.models.WebhookEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="endpointType")
@JsonTypeName(value="WebHook")
public final class WebhookEventSubscriptionDestination
extends EventSubscriptionDestination {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebhookEventSubscriptionDestination.class);
    @JsonProperty(value="properties")
    private WebhookEventSubscriptionDestinationProperties innerProperties;

    private WebhookEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String endpointUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointUrl();
    }

    public WebhookEventSubscriptionDestination withEndpointUrl(String endpointUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withEndpointUrl(endpointUrl);
        return this;
    }

    public String endpointBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointBaseUrl();
    }

    public Integer maxEventsPerBatch() {
        return this.innerProperties() == null ? null : this.innerProperties().maxEventsPerBatch();
    }

    public WebhookEventSubscriptionDestination withMaxEventsPerBatch(Integer maxEventsPerBatch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withMaxEventsPerBatch(maxEventsPerBatch);
        return this;
    }

    public Integer preferredBatchSizeInKilobytes() {
        return this.innerProperties() == null ? null : this.innerProperties().preferredBatchSizeInKilobytes();
    }

    public WebhookEventSubscriptionDestination withPreferredBatchSizeInKilobytes(Integer preferredBatchSizeInKilobytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withPreferredBatchSizeInKilobytes(preferredBatchSizeInKilobytes);
        return this;
    }

    public String azureActiveDirectoryTenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().azureActiveDirectoryTenantId();
    }

    public WebhookEventSubscriptionDestination withAzureActiveDirectoryTenantId(String azureActiveDirectoryTenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withAzureActiveDirectoryTenantId(azureActiveDirectoryTenantId);
        return this;
    }

    public String azureActiveDirectoryApplicationIdOrUri() {
        return this.innerProperties() == null ? null : this.innerProperties().azureActiveDirectoryApplicationIdOrUri();
    }

    public WebhookEventSubscriptionDestination withAzureActiveDirectoryApplicationIdOrUri(String azureActiveDirectoryApplicationIdOrUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withAzureActiveDirectoryApplicationIdOrUri(azureActiveDirectoryApplicationIdOrUri);
        return this;
    }

    public List<DeliveryAttributeMapping> deliveryAttributeMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryAttributeMappings();
    }

    public WebhookEventSubscriptionDestination withDeliveryAttributeMappings(List<DeliveryAttributeMapping> deliveryAttributeMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withDeliveryAttributeMappings(deliveryAttributeMappings);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

